#ifndef __CTime__
#define __CTime__

#include "../Basics/CString.hpp"
using Exponent::Basics::CString;

//	===========================================================================

namespace Exponent
{
	namespace Host
	{
		/**
		 * @class CTime CTime.hpp
		 * @brief Stores the current time
		 *
		 * @date 15/09/2004
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 * @version 1.1.0 Removed virtual from function definitions
		 * @version 1.1.1 Added object description
		 * @version 1.1.2 Improved const correctness
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 *
		 * $Id: CTime.hpp,v 1.4 2007/02/08 21:06:44 paul Exp $
		 */
		class CTime : public CCountedObject
		{
			/** @cond */
			EXPONENT_CLASS_DECLARATION;
			/** @endcond */

//	===========================================================================

		public:

//	===========================================================================

			const static char *CTIME_DAY_OF_THE_WEEK[];			/**< The days of the week */
			const static char *CTIME_MONTH_OF_THE_YEAR[];		/**< The months of the year */

//	===========================================================================

			/**
			 * Construction -> sets to current time
			 */
			CTime();
/** @cond */
#ifdef WIN32
/** @endcond */
			/**
			 * Construction from a time
			 * @param fileTime Window file time
			 */
			CTime(FILETIME &fileTime);
/** @cond */
#else
/** @endcond */
			/**
			 * Construction from a time
			 * @param time Mac file time
			 */
			CTime(DateTimeRec &time);
/** @cond */
#endif
/** @endcond */

			/**
			 * Copy construction
			 * @param time The time to copy
			 */
			CTime(const CTime &time);

			/**
			 * Destructor
			 */
			virtual ~CTime();

//	===========================================================================

			/**
			 * Assignment opertor
			 * @param time The time to copy
			 * @retval CTime& A reference to this
			 */
			virtual CTime &operator = (const CTime &time);

//	===========================================================================
/** @cond */
#ifdef WIN32
/** @endcond */
			/**
			 * Set the time from a windows filetime structure
			 * @param fileTime The window file time
			 */
			void setTime(FILETIME &fileTime);
/** @cond */
#else
/** @endcond */
			/**
			 * Construction from a time
			 * @param time Mac file time
			 */
			void setTime(DateTimeRec &time);
/** @cond */
#endif
/** @endcond */

			/**
			 * Set to the current time when called
			 */
			void setToCurrentTime();

//	===========================================================================

			/**
			 * Get the year
			 * @retval unsigned short The year
			 */
			unsigned short getYear() const { return m_year; }

			/**
			 * Get the months
			 * @retval unsigned short The months
			 */
			unsigned short getMonth() const { return m_month; }

			/**
			 * Get hte day of the week
			 * @retval unsigned short The day of the week
			 */
			unsigned short getDayOfWeek() const { return m_dayOfWeek; }

			/**
			 * Get the day of the month
			 * @retval unsigned short The day
			 */
			unsigned short getDay() const { return m_day; }

			/**
			 * Get the hour
			 * @retval unsigned short The hour
			 */
			unsigned short getHour() const { return m_hour; }

			/**
			 * Get the minute
			 * @retval unsigned short The minute
			 */
			unsigned short getMinutes() const { return m_minutes; }

			/**
			 * Get the seconds
			 * @retval unsigned short The seconds
			 */
			unsigned short getSeconds() const { return m_seconds; }

			/**
			 * Get the milliseconds
			 * @retval unsigned short The milliseconds
			 */
			unsigned short getMilliseconds() const { return m_milliseconds; }

//	===========================================================================

			/**
			 * Set the year
			 * @param year The year
			 */
			void setYear(const unsigned short year) { m_year = year; }

			/**
			 * Set the month
			 * @param month The month
			 */
			void setMonth(const unsigned short month) { m_month = month; }

			/**
			 * Set the day of the week
			 * @param dayOfWeek The day of the week
			 */
			void setDayOfWeek(const unsigned short dayOfWeek) { m_dayOfWeek = dayOfWeek; }

			/**
			 * Set the day
			 * @param day The day
			 */
			void setDay(const unsigned short day) { m_day = day; }

			/**
			 * Set the hour
			 * @param hour The hour
			 */
			void setHour(const unsigned short hour) { m_hour = hour; }

			/**
			 * Set the minutes
			 * @param minutes The minutes
			 */
			void setMinutes(const unsigned short minutes) { m_minutes = minutes; }

			/**
			 * Set the seconds
			 * @param seconds The seconds
			 */
			void setSeconds(const unsigned short seconds) { m_seconds = seconds; }

			/**
			 * Set the milliseconds
			 * @param milliseconds The milliseconds
			 */
			void setMilliseconds(const unsigned short milliseconds) { m_milliseconds = milliseconds; }

//	===========================================================================

			/**
			 * Get a description of the object
			 * @param string On return is filled with the description
			 * @param size The size of the stirng
			 */
			virtual void getObjectDescription(char *string, const long size) const;

//	===========================================================================

			/**
			 * Get the day and year string eg - either 12 SEptember 2004 or 12/09/04 if stringFormat = false
			 * @param stringFormat If true string is format Date Month Year as strings. If false is formated as dd/mm/yy
			 * @retval CString The day year string. Up to you to delete string returned
			 */
			CString getDayYearString(const bool stringFormat = true) const;

			/**
			 * Get the time as a string eg - hh:mm:sec:msec
			 * @retval CString The time string, up to you to delete string returned
			 */
			CString getTimeOnly() const;
/** @cond */
#ifdef WIN32
/** @endcond */
			/**
			 * Get the time as a filetime structure WIN32 ONLY
			 * @retval FILETIME The date as a FILETIMNE for win - you are responsible for pointer deletion
			 */
			FILETIME *getFileTime();
/** @cond */
#else
/** @endcond */
			/**
			 * Get the time as a macos datetimerec MAC ONLY
			 * @retval DateTimeRect* The date as a DatTimeRec for mac - you are responsible for pointer deletion
			 */
			DateTimeRec *getFileTime();
/** @cond */
#endif
/** @endcond */

//	===========================================================================

		protected:

//	===========================================================================
/** @cond */
#ifdef WIN32
/** @endcond */
			/**
			 * Set the time
			 * @param time The windows system time
			 */
			void setTime(SYSTEMTIME &time);
/** @cond */
#endif
/** @endcond */

//	===========================================================================

			unsigned short m_year;					/**< The year */
			unsigned short m_month;					/**< The month */
			unsigned short m_dayOfWeek;				/**< The day of the week */
			unsigned short m_day;					/**< The day */
			unsigned short m_hour;					/**< The hour */
			unsigned short m_minutes;				/**< The minutes */
			unsigned short m_seconds;				/**< The seconds */
			unsigned short m_milliseconds;			/**< The milliseconds */
		};
	}
}
#endif	// End of CTime.hpp
